#ifndef CHUNKDT_H
#define CHUNKDT_H
// CHUNK DATA TYPES
#include "dblreader.h"

#define DB_TEXTURE_CONTEXT			103
#define DB_TEXTURE_CONTEXT2			99
#define DB_AISCRIPT					37
#define DB_ANIMSCRIPT				38
#define DB_ANIMATED_TEXTURE_SET		135
#define DB_MERGED_TEXTURE_SET		134
#define DB_TEXTURE_SET				130
#define DB_PARTICLE_EMITTER			100
#define DB_PARTICLE_SOURCE			101
#define DB_PARTICLE_EFFECT			102
#define DB_EXPANSION_TABLE			99
#define DB_GROUP					97
#define DB_INSTANCE					96
#define DB_LOD						98
#define DB_SOMARRAYBONE				35
#define DB_SOMARRAY					34
#define DB_SINGLSOMBONE				33
#define DB_SINGLSOM					32
#define DB_COLLISIONSOMARRAY		36
#define DB_WORLD_EMITTERS			144
#define DB_WORLD_DISTORTIONS		145
#define DB_PARTICLE_SURFACE_LIST	137
#define DB_PARTICLE_LIST			133
#define DB_EMITTER_LIST				132
#define DB_VIS_REGIONS				105
#define DB_SCENE_TREE				104

#define DT_DBTEXTURE_CONTEXT			0
#define DT_DBTEXTURE_CONTEXT2			1
#define DT_DBAISCRIPT					2
#define DT_DBANIMSCRIPT					3
#define DT_DBANIMATED_TEXTURE_SET		4
#define DT_DBMERGED_TEXTURE_SET			5
#define DT_DBTEXTURE_SET				6
#define DT_DBPARTICLE_EMITTER			7
#define DT_DBPARTICLE_SOURCE			8
#define DT_DBPARTICLE_EFFECT			9
#define DT_DBEXPANSION_TABLE			10
#define DT_DBGROUP						11
#define DT_DBINSTANCE					12
#define DT_DBLOD						13
#define DT_DBSOMARRAYBONE				14
#define DT_DBSOMARRAY					15
#define DT_DBSINGLSOMBONE				16
#define DT_DBSINGLSOM					17
#define DT_DBCOLLISIONSOMARRAY			18
#define DT_DBWORLD_EMITTERS				19
#define DT_DBWORLD_DISTORTIONS			20
#define DT_DBPARTICLE_SURFACE_LIST		21
#define DT_DBPARTICLE_LIST				22
#define DT_DBEMITTER_LIST				23
#define DT_DBVIS_REGIONS				24
#define DT_DBSCENE_TREE					25

extern INT16 Chunk_DataTypes[26];
extern INT16 Chunk_VersionConsistency[26];

// Gets a char array of the datatype name
char* ChunkDataTypeToString( dbl_chunk_header_s* pChunkInfo );

// Gets a byte representation of the datatype from the given string
INT16 ChunkDataTypeFromString( String^ dt );

// Check for version consistency
BOOL CheckChunkDataTypeForVersion( INT chunktype, INT version );

#endif